// fwd.hpp

// Boost Logging library
//
// Author: John Torjo, www.torjo.com
//
// Copyright (C) 2007 John Torjo (see www.torjo.com for email)
//
//  SPDX-License-Identifier: BSL-1.0
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)
//
// See http://www.boost.org for updates, documentation, and revision history.
// See http://www.torjo.com/log2/ for more details

#ifndef JT28092007_fwd_HPP_DEFINED
#define JT28092007_fwd_HPP_DEFINED

#include <hpx/config.hpp>

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include <hpx/logging/detail/macros.hpp>

// minimize inclusion of STL headers in our headers!!!
#include <string>

/*
    Important: we define here only the things that are needed by ALL OF THE LIBRARY.
    So be very careful when modifying this file
    - we don't want any circular dependencies!

    If unsure where to place something, place it logging.hpp!
*/

namespace hpx { namespace util { namespace logging {

    namespace optimize {
        struct cache_string_one_str;
    }

    typedef optimize::cache_string_one_str msg_type;

    /**
@page dealing_with_flags Dealing with flags.

Some classes have extra settings. You can specify these settings in the
class'es constructor.
When setting a certain value, there's a very simple pattern:

@code
some_object obj(..., some_object_settings().setting1(value1).setting2(value2)....);
@endcode

Example:

@code
using namespace destination;
file f("out.txt", file_settings.initial_overwrite(true).do_append(false) );
@endcode

*/

    namespace detail {
        template <class self_type, class type>
        struct flag_with_self_type
        {
            flag_with_self_type(self_type* self, const type& val = type())
              : m_val(val)
              , m_self(self)
            {
            }
            flag_with_self_type(flag_with_self_type const& other)
              : m_val(other.m_val)
              , m_self(other.m_self)
            {
            }

            const type& operator()() const
            {
                return m_val;
            }
            self_type& operator()(const type& val)
            {
                m_val = val;
                return *m_self;
            }

            flag_with_self_type& operator=(self_type const& other)
            {
                m_val = other.m_val;
                return *this;
            }
            flag_with_self_type& operator=(flag_with_self_type const& other)
            {
                m_val = other.m_val;
                m_self = other.m_self;
                return *this;
            }

        private:
            type m_val;
            self_type* m_self;
        };

        /**
        @brief Can hold a flag. See dealing_with_flags
    */
        template <class self_type>
        struct flag
        {
            template <class val_type>
            struct t : flag_with_self_type<self_type, val_type>
            {
                typedef flag_with_self_type<self_type, val_type> flag_base_type;
                t(self_type* self, const val_type& val = val_type())
                  : flag_base_type(self, val)
                {
                }
            };
        };
    }    // namespace detail

}}}    // namespace hpx::util::logging

#endif
