//  Copyright (c) 2017 Mikael Simberg
//
//  SPDX-License-Identifier: BSL-1.0
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

// Simple test verifying basic resource_partitioner functionality.

#include <hpx/hpx_init.hpp>
#include <hpx/include/resource_partitioner.hpp>
#include <hpx/include/threads.hpp>
#include <hpx/testing.hpp>

#include <cstddef>
#include <stdexcept>
#include <string>
#include <utility>
#include <vector>

int hpx_main(int argc, char* argv[])
{
    // Try suspending without elasticity enabled, should throw an exception
    bool exception_thrown = false;

    try
    {
        hpx::threads::thread_pool_base& tp =
            hpx::resource::get_thread_pool("default");

        // Use .get() to throw exception
        hpx::threads::suspend_processing_unit(tp, 0).get();
        HPX_TEST_MSG(false, "Suspending should not be allowed with "
            "elasticity disabled");
    }
    catch (hpx::exception const&)
    {
        exception_thrown = true;
    }

    HPX_TEST(exception_thrown);

    return hpx::finalize();
}

int main(int argc, char* argv[])
{
    std::vector<std::string> cfg =
    {
        "hpx.os_threads=4"
    };

    hpx::resource::partitioner rp(argc, argv, std::move(cfg));

    // Explicitly disable elasticity if it is in defaults
    rp.create_thread_pool("default",
        hpx::resource::scheduling_policy::local_priority_fifo,
        hpx::threads::policies::scheduler_mode(
            hpx::threads::policies::default_mode &
            ~hpx::threads::policies::enable_elasticity));

    HPX_TEST_EQ(hpx::init(argc, argv), 0);
}
